<?php
// Verifique se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtenha os dados do formulário
    $user_mac = isset($_POST['mac_address']) ? $_POST['mac_address'] : '';
    $new_mac_value = isset($_POST['mac_value']) ? $_POST['mac_value'] : '';

    // Caminho para o arquivo JSON
    $json_file = '../a/device_keys.json';

    // Verifique se o arquivo JSON existe
    if (file_exists($json_file)) {
        // Obtenha os dados do arquivo JSON
        $json_data = file_get_contents($json_file);
        $device_keys = json_decode($json_data, true);

        // Verifique se o MAC address existe no arquivo JSON
        if (isset($device_keys[$user_mac])) {
            // Atualize o valor do MAC address
            $device_keys[$user_mac] = $new_mac_value;

            // Salve o arquivo JSON com os novos dados
            $updated_json_data = json_encode($device_keys, JSON_PRETTY_PRINT);
            file_put_contents($json_file, $updated_json_data);

            // Redirecione de volta com uma mensagem de sucesso
            header('Location: ../revenda/index.php?status=success');
            exit();
        } else {
            // Se o MAC address não existir, redirecione com uma mensagem de erro
            header('Location: ../revenda/index.php?status=error&message=MAC address não encontrado');
            exit();
        }
    } else {
        // Se o arquivo JSON não existir, redirecione com uma mensagem de erro
        header('Location: ../revenda/index.php?status=error&message=Arquivo JSON não encontrado');
        exit();
    }
}
?>
