<?php
// Verificar se a sessão foi iniciada
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

if (!isset($_SESSION['id'])) {
    die('Sessão expirada ou usuário não autenticado.');
}

if (!isset($_SESSION['seller_name'])) {
    die('Nome do reseller não definido na sessão.');
}

$seller_name = $_SESSION['seller_name'];

$db = new SQLite3(__DIR__ . '/../a/.eggziedb.db');

$message = '';
$error = '';
$mac_address_found = false;
$mac_data = [];

// Buscar dados de um MAC Address específico
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['mac_address'])) {
    $mac_address = strtolower(trim($db->escapeString($_POST['mac_address'])));
    $result = $db->query("SELECT id, mac_address, seller FROM ibo WHERE LOWER(mac_address) = '$mac_address'");

    $mac_data = [];
    while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
        $mac_data[] = $row;
    }

    if (!empty($mac_data)) {
        $mac_address_found = true;
    } else {
        $error = 'MAC Address não encontrado.';
    }
}


// Excluir um MAC Address específico
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_mac_id'])) {
    $delete_mac_id = $db->escapeString($_POST['delete_mac_id']);
    $db->exec("DELETE FROM ibo WHERE id = '$delete_mac_id'");
    $message = 'MAC Address excluído com sucesso!';
    $mac_address_found = false; // Esconder a tabela após excluir
}

include __DIR__ . '/../includes/header2.php';
?>

<style>
    .table-responsive {
        overflow-x: auto;
        white-space: nowrap;
    }
</style>

<main role="main" class="container pt-4">
    <div class="row justify-content-center">
        <div id="main" class="col-12">
            <img src="fotodns.png" alt="Imagem de Migração DNS" class="img-fluid mx-auto d-block" style="max-width: 100px;" />

            <?php if (!empty($message)) : ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $message; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>
            <?php if (!empty($error)) : ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $error; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <h1 class="h3 mb-3 text-gray-800 text-center">Buscar MAC Address</h1>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="mac_address">Digite o MAC Address</label>
                    <input type="text" class="form-control" id="mac_address" name="mac_address" required>
                </div>
                <button type="submit" class="btn btn-primary">Buscar</button>
            </form>

           <?php if ($mac_address_found) : ?>
    <hr>
    <h3 class="text-center">Resultados encontrados</h3>
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>MAC Address</th>
                    <th>Revenda</th>
                    <th>Ação</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($mac_data as $mac) : ?>
                    <tr>
                        <td><?php echo htmlspecialchars($mac['id']); ?></td>
                        <td><?php echo htmlspecialchars($mac['mac_address']); ?></td>
                        <td><?php echo htmlspecialchars($mac['seller']); ?></td>
                        <td>
                            <form method="POST" action="" style="display:inline;">
                                <input type="hidden" name="delete_mac_id" value="<?php echo $mac['id']; ?>">
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Tem certeza que deseja excluir este MAC Address?');">
                                    Excluir
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

        </div>
    </div>
</main>

<?php include __DIR__ . '/../includes/footer2.php'; ?>

<script>
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
</script>

</body>
</html>
