<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$db = new SQLite3('a/.eggziedb.db');

$message = '';
$default_expire_date = date('Y-m-d', strtotime('+1 year'));

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['mac_address'])) {
    $mac_address = $db->escapeString($_POST['mac_address']);
    $result = $db->querySingle("SELECT * FROM ibo WHERE LOWER(mac_address) = LOWER('$mac_address')", true);

}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update'])) {
    $mac_address = strtoupper(trim($db->escapeString($_POST['mac_address']))); // Converter para MAIÚSCULAS
    $username = $db->escapeString($_POST['username']);
    $password = $db->escapeString($_POST['password']);
    $expire_date = $db->escapeString($_POST['expire_date']);
    $url = $db->escapeString($_POST['url']);
    $title = $db->escapeString($_POST['title']);
    $seller = $db->escapeString($_POST['seller']);

    // Verificar se o MAC Address já existe antes de atualizar
    $check_query = $db->query("SELECT COUNT(*) as count FROM ibo WHERE UPPER(mac_address) = UPPER('$mac_address')");
    $result = $check_query->fetchArray();

    if ($result['count'] > 0) {
        // Atualizando o banco de dados e forçando maiúsculas no SQL
        $update_query = "UPDATE ibo SET 
                        mac_address = UPPER('$mac_address'), 
                        username = '$username', 
                        password = '$password', 
                        expire_date = '$expire_date', 
                        url = '$url', 
                        title = '$title', 
                        seller = '$seller' 
                        WHERE UPPER(mac_address) = UPPER('$mac_address')";

        if ($db->exec($update_query)) {
            $message = 'Dados atualizados com sucesso!';
        } else {
            $error = 'Erro ao atualizar os dados. Verifique as informações.';
        }
    } else {
        $error = 'MAC Address não encontrado no banco de dados.';
    }
}

include 'includes/header.php';
?>

<main role="main" class="container pt-4">
    <div class="row justify-content-center">
        <div id="main" class="col-12">
            <div class="text-center">
    <img src="fotodns.png" alt="Imagem de Migração DNS" class="img-fluid mx-auto d-block" style="max-width: 100px;" />
    <h1 class="h3 mb-3 text-gray-800">Buscar MAC Address</h1>
</div>

            
            <?php if (!empty($message)) : ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $message; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="mac_address">Digite o MAC Address</label>
                    <input type="text" class="form-control" id="mac_address" name="mac_address" required>
                </div>
                <button type="submit" class="btn btn-primary">Buscar</button>
            </form>
            
            <?php if (!empty($result)) : ?>
                <h2 class="mt-4">Editar Informações</h2>
                <form method="POST" action="">
                    <input type="hidden" name="mac_address" value="<?php echo htmlspecialchars($result['mac_address']); ?>">
                    <div class="form-group">
                        <label>Username</label>
                        <input type="text" class="form-control" name="username" value="<?php echo htmlspecialchars($result['username']); ?>">
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input type="text" class="form-control" name="password" value="<?php echo htmlspecialchars($result['password']); ?>">
                    </div>
                    <div class="form-group">
                        <label>Vencimento</label>
                        <input type="date" class="form-control" name="expire_date" value="<?php echo !empty($result['expire_date']) ? htmlspecialchars($result['expire_date']) : $default_expire_date; ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label>URL</label>
                        <input type="text" class="form-control" name="url" value="<?php echo htmlspecialchars($result['url']); ?>">
                    </div>
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" class="form-control" name="title" value="<?php echo htmlspecialchars($result['title']); ?>">
                    </div>
                    <div class="form-group">
                        <label>Deixar Em Branco [ADM]:</label>
                        <input type="text" class="form-control" name="seller" value="<?php echo htmlspecialchars($result['seller']); ?>">
                    </div>
                    <button type="submit" class="btn btn-success" name="update">Salvar Alterações</button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php
include 'includes/footer.php';
?>

<script>
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
</script>
</body>
</html>
