<?php
if (isset($_GET['mac_address'])) {
    $mac_address = $_GET['mac_address'];

    // Normaliza o valor do mac_address (remove espaços e converte para maiúsculas)
    $mac_address = strtoupper(trim($mac_address));

    // Depuração: Verifica o valor do mac_address recebido
    error_log("MAC Address recebido: " . $mac_address);
    
    // Caminho para o arquivo JSON
    $path = 'a/device_keys.json';
    
    // Verifica se o arquivo JSON existe
    if (!file_exists($path)) {
        echo json_encode(['deviceKey' => 'Arquivo não encontrado']);
        exit;
    }

    // Lê o conteúdo do arquivo JSON
    $deviceKeys = json_decode(file_get_contents($path), true);
    
    // Verifica se o conteúdo do arquivo JSON foi decodificado corretamente
    if ($deviceKeys === null) {
        echo json_encode(['deviceKey' => 'Erro ao decodificar o arquivo JSON']);
        exit;
    }

    // Depuração: Exibe o conteúdo do JSON
    error_log("Conteúdo do JSON: " . print_r($deviceKeys, true));

    // Verifica se o mac_address existe no arquivo JSON
    if (isset($deviceKeys[$mac_address])) {
        $response = ['deviceKey' => $deviceKeys[$mac_address]];
    } else {
        // Se não encontrado, verifica se a chave foi encontrada ou se o mac_address está no formato correto
        error_log("MAC Address não encontrado no arquivo JSON: " . $mac_address);
        $response = ['deviceKey' => 'Não encontrado'];
    }

    // Retorna a resposta em formato JSON
    echo json_encode($response);
} else {
    echo json_encode(['deviceKey' => 'Erro: MAC Address não fornecido']);
}
?>
