<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$db = new SQLite3('a/.eggziedb.db');

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['mac_address'])) {
    $mac_address = strtolower(trim($db->escapeString($_POST['mac_address'])));
    $result = $db->query("SELECT * FROM ibo WHERE LOWER(mac_address) = '$mac_address'");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete'])) {
    $id = $db->escapeString($_POST['id']);
    $db->exec("DELETE FROM ibo WHERE id = '$id'");
    $message = 'Registro excluído com sucesso!';
}

include 'includes/header.php';
?>

<style>
    .table-responsive {
        overflow-x: auto;
        white-space: nowrap;
    }
</style>

<main role="main" class="container pt-4">
    <div class="row justify-content-center">
        <div id="main" class="col-12">
            <div class="text-center">
                <img src="fotodns.png" alt="Imagem de Migração DNS" class="img-fluid mx-auto d-block" style="max-width: 100px;" />
                <h1 class="h3 mb-3 text-gray-800">Buscar MAC Address</h1>
            </div>

            <?php if (!empty($message)) : ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $message; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="mac_address">Digite o MAC Address</label>
                    <input type="text" class="form-control" id="mac_address" name="mac_address" required>
                </div>
                <button type="submit" class="btn btn-primary">Buscar</button>
            </form>

            <?php if (isset($result) && $result !== false) : ?>
                <h2 class="mt-4">Resultados</h2>
                <div class="table-responsive">
                    <table class="table table-bordered mt-3">
                        <thead>
                            <tr>
                                <th>MAC Address</th>
                                <th>Revenda</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetchArray(SQLITE3_ASSOC)) : ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['mac_address']); ?></td>
                                    <td><?php echo htmlspecialchars($row['seller']); ?></td>
                                    <td>
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                            <button type="submit" class="btn btn-danger btn-sm" name="delete" onclick="return confirm('Tem certeza que deseja excluir este registro?');">Excluir</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>

<script>
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
</script>

</body>
</html>
